<?php
require_once __DIR__ . '/../config/database.php';

try {
    $pdo = new PDO(
        "mysql:host=" . DB_HOST . ";dbname=" . DB_NAME . ";charset=utf8mb4",
        DB_USER,
        DB_PASS,
        [
            PDO::ATTR_PERSISTENT => true,
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
            PDO::ATTR_EMULATE_PREPARES => false,
            PDO::MYSQL_ATTR_INIT_COMMAND => "SET NAMES utf8mb4 COLLATE utf8mb4_unicode_ci"
        ]
    );

    // Check if permissions already exist
    $existingPermissions = ['process_supplier_payment', 'add_supplier_item', 'search_suppliers'];
    
    foreach ($existingPermissions as $permission) {
        $stmt = $pdo->prepare("SELECT COUNT(*) FROM permissions WHERE name = ?");
        $stmt->execute([$permission]);
        $exists = $stmt->fetchColumn() > 0;
        
        if (!$exists) {
            // Add the permission
            $stmt = $pdo->prepare("INSERT INTO permissions (name, description) VALUES (?, ?)");
            
            switch ($permission) {
                case 'process_supplier_payment':
                    $stmt->execute([$permission, 'Process supplier payments']);
                    break;
                case 'add_supplier_item':
                    $stmt->execute([$permission, 'Add items from suppliers']);
                    break;
                case 'search_suppliers':
                    $stmt->execute([$permission, 'Search suppliers']);
                    break;
            }
            
            echo "Added permission: $permission\n";
        } else {
            echo "Permission already exists: $permission\n";
        }
    }
    
    echo "Migration completed successfully!\n";
    
} catch (PDOException $e) {
    echo "Migration failed: " . $e->getMessage() . "\n";
}
?> 